unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, OleCtnrs, Menus;

type
  TForm1 = class(TForm)
    OleContainer1: TOleContainer;
    MainMenu1: TMainMenu;
    Plik1: TMenuItem;
    Zamknij1: TMenuItem;
    Paint1: TMenuItem;
    Zakoczedycj1: TMenuItem;
    Otwrz1: TMenuItem;
    Zakoczedycj2: TMenuItem;
    N1: TMenuItem;
    Pokapolecenia1: TMenuItem;
    Wstawianieobiektu1: TMenuItem;
    WstawdokumentWord1: TMenuItem;
    WstawarkuszExcel1: TMenuItem;
    WstawrysunekPaint1: TMenuItem;
    Wybierzplik1: TMenuItem;
    procedure Wybierzplik1Click(Sender: TObject);
    procedure WstawrysunekPaint1Click(Sender: TObject);
    procedure WstawarkuszExcel1Click(Sender: TObject);
    procedure WstawdokumentWord1Click(Sender: TObject);
    procedure Wstawianieobiektu1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure OleContainer1Deactivate(Sender: TObject);
    procedure Pokapolecenia1Click(Sender: TObject);
    procedure Zakoczedycj2Click(Sender: TObject);
    procedure Otwrz1Click(Sender: TObject);
    procedure Edytuj1Click(Sender: TObject);
    procedure Zamknij1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Zamknij1Click(Sender: TObject);
begin
Close;
end;

procedure TForm1.Edytuj1Click(Sender: TObject);
begin
OleContainer1.DoVerb(ovPrimary);
end;

procedure TForm1.Otwrz1Click(Sender: TObject);
begin
OleContainer1.DoVerb(1);
end;

procedure TForm1.Zakoczedycj2Click(Sender: TObject);
begin
OleContainer1.Close;
end;

procedure TForm1.Pokapolecenia1Click(Sender: TObject);
begin
ShowMessage(OleContainer1.ObjectVerbs.Text);
end;

procedure TForm1.OleContainer1Deactivate(Sender: TObject);
begin
ShowMessage('Zamykanie edytora');
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
if (OleContainer1.State<>osLoaded) then
   case Application.MessageBox('Czy zakoczy edycj?',PChar(Caption),MB_YESNOCANCEL) of
    IDYES: OleContainer1.Close;
    IDNO: ShowMessage('Zmiany nie zostan zachowane');
    IDCANCEL: CanClose:=False;
   end;
end;

procedure TForm1.Wstawianieobiektu1Click(Sender: TObject);
begin
OleContainer1.InsertObjectDialog;
end;

procedure TForm1.WstawdokumentWord1Click(Sender: TObject);
begin
OleContainer1.DestroyObject;
OleContainer1.CreateObject('Word.Document',False);
OleContainer1.DoVerb(ovPrimary);
end;

procedure TForm1.WstawarkuszExcel1Click(Sender: TObject);
begin
OleContainer1.DestroyObject;
OleContainer1.CreateObject('Excel.Sheet',False);
OleContainer1.DoVerb(ovPrimary);
end;

procedure TForm1.WstawrysunekPaint1Click(Sender: TObject);
begin
OleContainer1.DestroyObject;
OleContainer1.CreateObject('Paint.Picture',False);
OleContainer1.DoVerb(ovPrimary);
end;

procedure TForm1.Wybierzplik1Click(Sender: TObject);
var OpenDialog :TOpenDialog;
begin
OpenDialog:=TOpenDialog.Create(Self);
if OpenDialog.Execute then
  begin
  OleContainer1.DestroyObject;
  OleContainer1.CreateObjectFromFile(OpenDialog.FileName,False);
  OleContainer1.DoVerb(ovPrimary);
  end;
OpenDialog.Free;
end;

end.
